#include <Keyboard.h>
//
// PLAYER 1
//
const int player1ButtonA = 0;     
const int player1ButtonB = 1;
const int player1ButtonC = 2;
const int player1ButtonD = 3;

const int player1XAxis = A0;
const int player1YAxis = A1;
int player1XValue = 0;
int player1YValue = 0;
//
// PLAYER 2
//
const int player2ButtonA = 4;     
const int player2ButtonB = 5;
const int player2ButtonC = 6;
const int player2ButtonD = 7;
const int player2XAxis = A2;
const int player2YAxis = A3;
int player2XValue = 0;
int player2YValue = 0;
 
void setup() 
{
  pinMode(player1ButtonA, INPUT_PULLUP);
  pinMode(player1ButtonB, INPUT_PULLUP);
  pinMode(player1ButtonC, INPUT_PULLUP);
  pinMode(player1ButtonD, INPUT_PULLUP);
  
  //
  // PLAYER 2
  //
  pinMode(player2ButtonA, INPUT_PULLUP);
  pinMode(player2ButtonB, INPUT_PULLUP);
  pinMode(player2ButtonC, INPUT_PULLUP);
  pinMode(player2ButtonD, INPUT_PULLUP);
  Keyboard.begin();
}

int treatValue(int data) 
{
  return (data * 9 / 1024) + 10 ;
 }
void loop() 
{
  //
  // PLAYER 1
  //
  if(digitalRead(player1ButtonA)==LOW )
  {
    Keyboard.write('E');
    //Serial.print("E");
  }
  if(digitalRead(player1ButtonB)==LOW )
  {
    Keyboard.write('Q');
    //Serial.print("Q");
  }
  if(digitalRead(player1ButtonC)==LOW )
  {
    Keyboard.write(32);
    //Serial.print("Space");
  }
  if(digitalRead(player1ButtonD)==LOW )
  {
    Keyboard.write('R');
    //Serial.print("R");
  }
  
  player1XValue = analogRead(player1XAxis);  
  player1YValue = analogRead(player1YAxis); 

  if(treatValue(player1XValue) > 16)
  {
    Keyboard.write('A');
  }
  else if(treatValue(player1XValue) < 12)
  {
    Keyboard.write('D');
  }

  if(treatValue(player1YValue) > 16)
  {
    Keyboard.write('W');
  }
  else if(treatValue(player1YValue) < 12)
  {
    Keyboard.write('S');
  }
  //
  // PLAYER 2
  //
  if(digitalRead(player2ButtonA)==LOW )
  {
    Keyboard.write('O');
    //Serial.print("O");
    
  }
  if(digitalRead(player2ButtonB)==LOW )
  {
    Keyboard.write('U');
    //Serial.print("U");
  }
  if(digitalRead(player2ButtonC)==LOW )
  {
    Keyboard.write(176);
    //Serial.print("Enter");
  }
  if(digitalRead(player2ButtonD)==LOW )
  {
    Keyboard.write('P');
    //Serial.print("P");
  }
  
  player2XValue = analogRead(player2XAxis);  
  player2YValue = analogRead(player2YAxis);  
  /*Serial.print(treatValue(player1XValue));
  Serial.print(" , ");
  Serial.print(treatValue(player1YValue));
  Serial.print(" :: ");
  Serial.print(treatValue(player2XValue));
  Serial.print(" , ");
  Serial.println(treatValue(player2YValue));*/
  
  if(treatValue(player2XValue) > 14)
  {
    Keyboard.write('J');
  }
  else if(treatValue(player2XValue) < 11)
  {
    Keyboard.write('L');
  }

  if(treatValue(player2YValue) > 14)
  {
    Keyboard.write('I');
  }
  else if(treatValue(player2YValue) < 11)
  {
    Keyboard.write('K');
  }
  delay(5);
 }
