#include <Keyboard.h>

const int VERT = A0; // analog
const int HORIZ = A2; // analog
const int btn2 = 2;

char leftKey = KEY_LEFT_ARROW;
char rightKey = KEY_RIGHT_ARROW;
char upKey = KEY_UP_ARROW;
char downKey = KEY_DOWN_ARROW;
char enter = KEY_RETURN;

void setup() {
  // put your setup code here, to run once:
  pinMode(btn2, INPUT_PULLUP);
  
  Serial.begin(9600);
  Keyboard.begin();
}

void loop() {
  // put your main code here, to run repeatedly:

  int vertical, horizontal;
  
  // read all values from the joystick
  
  vertical = analogRead(VERT); // will be 0-1023
  horizontal = analogRead(HORIZ); // will be 0-1023

  
  Serial.print("X-axis: " + (String)horizontal);
  Serial.flush();
  delay(10);
  Serial.println("Y-axis: " + (String)vertical);
  Serial.flush();
  delay(10);

  if (digitalRead(btn2) == LOW) {
    Keyboard.press(enter);
    Keyboard.release(enter);
    delay(500);
    
  }

  if(horizontal > 700) {
  Keyboard.release(downKey);
  Keyboard.press(upKey);
  delay(20);
  }
  
  
  if(horizontal < 450) {
  Keyboard.release(upKey);
  Keyboard.press(downKey);
  delay(20);
  }
  
  
  if(vertical > 700) {
  Keyboard.release(rightKey);
  Keyboard.press(leftKey);
  delay(100);
  }
  
  
  if(vertical < 500) {
  Keyboard.release(leftKey);
  Keyboard.press(rightKey);
  delay(100);
  }

  if(vertical > 451 && vertical < 999 && horizontal > 451 && horizontal < 699) {
  Keyboard.release(upKey);
  Keyboard.release(downKey);
  Keyboard.release(rightKey);
  Keyboard.release(leftKey);
  delay(10);
  
  }

}
